﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="VIRP_WEB.Custom.BPR.Registrants.CcowSiteCode" Codebehind="CcowSiteCode.aspx.cs" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlDropDownList.ascx" tagname="BaseControlDropDownList" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="Server">
    <script type="text/javascript" language="javascript">
        var sentillionDesc = "<% Response.Write(SentillionReasonDesc); %>";
        var sentillionCode = "<% Response.Write(SentillionReasonCode); %>";
        var contextDesc = "<% Response.Write(ContextReasonDesc); %>";
        var contextCode = "<% Response.Write(ContextReasonCode); %>";
        var requestStationAction = "<% Response.Write(RequestStationAction); %>";
        var confirmAction = "<% Response.Write(ConfirmAction); %>";
        var actionQueryField = "<% Response.Write(ActionQueryField); %>";
        var vistaQueryField = "<% Response.Write(VistaQueryField); %>";
        var reasonQueryField = "<% Response.Write(ReasonQueryField); %>";
    </script>

    <asp:Literal runat="Server" ID="DefaultJavascript">

<object id="ContextorControl" data="data:application/x-oleobject;base64,96x4h6lc0xGHJwBgsLXhNwADAADYEwAA2BMAAA=="
	classid="CLSID:8778ACF7-5CA9-11D3-8727-0060B0B5E137" name="ContextorControl" >
</object>

<script type="text/javascript" language="JavaScript" for="window" event="onLoad()">
    startSentillion();
</script>

<script type="text/javascript" language="javascript">

    var foundID = null;
    var action = null;
    var reason = null;

    function startSentillion() {
        appcode = ""
        appname = "CCOWDisplayer#"
        surveyable = true;
        try {
            ContextorControl.Run(appname, appcode, surveyable);
        } catch (errorObject) {
            //The Sentillion components were not found. Show an error and the site selection box.
            action = requestStationAction;
            reason = sentillionCode;
            setTimeout(ContinueToApplication, 50);
            return;
        }
        processContext(ContextorControl.CurrentContext);
    }


    function processContext(contextItems) {
        try {
            var coll = new Enumerator(contextItems);
            if (coll.atEnd()) {
                //The Sentillion components were found but there is no context.
                LogNoContextFound();
                return;
            }
            //The Sentillion components were found and there is context.
            for (; !coll.atEnd() ; coll.moveNext()) {
                var itemName = coll.item().name;
                var itemValue = coll.item().value;
                if (itemName == "user.id.logon.vistalogon") {
                    //We have everything we need to test the user credentials.
                    action = confirmAction;
                    foundID = itemValue;
                    setTimeout(ContinueToApplication, 50);
                    return;
                }
            }
            //The Sentillion components were found but the field we need was not found in the context. Show the station selection box.
            action = requestStationAction;
            reason = contextCode;
            setTimeout(ContinueToApplication, 50);
        } catch (errorObject) {
            addToDisplay(errorObject.message, errorObject.description);
        }
    }

    function GetBaseLocation() {
        var loc = new String(window.location);
        var found = loc.indexOf('?', 0);
        if (found > 0)
            loc = loc.substring(0, found - 1);
        found = loc.indexOf('#');
        if (found > 0)
            loc = loc.substring(0, found - 1);
        return loc;
    }

    function LogNoContextFound() {
        try {
            var loc = GetBaseLocation();
            var req = new XMLHttpRequest();
            req.open("POST", loc);
            req.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");
            req.send("Error: No Context Found");
        }
        catch (x) {
            //if it doesn't make it to the log there's not much we can do - already displaying error to user
        }
    }

    function ContinueToApplication() {
        window.navigate("CprsLaunch.aspx?from=ccowpage" + "&" + actionQueryField + "=" + action + "&" + vistaQueryField + "=" + foundID + "&" + reasonQueryField + "=" + reason);
    }
</script>

    </asp:Literal>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

     <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Loading..."/>
    </div>
 </asp:Content>

